/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.vw.api.VWException;
import filenet.ws.api.wsrr.P8WSRRDocumentURI;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.WSWSRRUtilities;
import filenet.ws.api.wsrr.commonj.sdo.DataGraphType;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.BaseObject;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.UserDefinedProperty;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLDocument;
import java.util.Hashtable;

public class WSWSRRWsdlDocument {
    WSWSRRRegistry m_wsrrRegistry = null;
    private WSDLDocument m_wsdlDocument = null;
    private String m_location = null;
    private String m_content = null;
    private P8WSRRDocumentURI m_p8WSRRDocumentURI = null;
    private UserDefinedProperty[] m_props = null;
    private DataGraphType m_dg = null;
    private Hashtable m_properties = null;

    public WSWSRRWsdlDocument(WSWSRRRegistry wsrrRegistry, String wsrrBsrURI) throws VWException {
        if (wsrrRegistry == null) {
            throw new VWException("filenet.ws.api.MissingWSRRServerURL", "Missing WSRR registry object");
        }
        this.m_wsrrRegistry = wsrrRegistry;
        DataGraphType dg = wsrrRegistry.retrieveWSDLDocument(wsrrBsrURI);
        this.init(dg);
    }

    public WSWSRRWsdlDocument(WSWSRRRegistry wsrrRegistry, DataGraphType dg) throws VWException, Exception {
        if (wsrrRegistry == null) {
            throw new VWException("filenet.ws.api.MissingWSRRServerURL", "Missing WSRR registry object");
        }
        this.m_wsrrRegistry = wsrrRegistry;
        if (dg == null) {
            throw new VWException("filenet.ws.api.MissingWSRRWsdlDocument", "Missing WSRR WSDL document");
        }
        this.init(dg);
    }

    private void init(DataGraphType dg) throws VWException {
        this.m_dg = dg;
        BaseObject baseObject = WSWSRRUtilities.getRootObject(this.m_dg);
        if (baseObject != null && baseObject instanceof WSDLDocument) {
            this.m_wsdlDocument = (WSDLDocument)baseObject;
        }
        if (this.m_wsdlDocument == null) {
            throw new VWException("filenet.ws.api.UnableToRetrieveWSRRWsdlDocument", "Unable to retrieve WSRR WSDL document");
        }
        this.m_location = this.m_wsdlDocument.getLocation();
        this.m_content = new String(this.m_wsdlDocument.getContent());
        this.m_props = this.m_wsdlDocument.getUserDefinedProperties();
        if (this.m_props != null && this.m_props.length > 0) {
            this.m_properties = new Hashtable();
            for (int i = 0; i < this.m_props.length; ++i) {
                this.m_properties.put(this.m_props[i].getName().trim(), this.m_props[i].getValue().trim());
            }
        }
        this.m_p8WSRRDocumentURI = new P8WSRRDocumentURI(this.m_wsrrRegistry, this.m_wsdlDocument.getBsrURI());
    }

    public DataGraphType getDataGraphType() {
        return this.m_dg;
    }

    public static String getWsdlDocumentContent(WSDLDocument wsdlDocument) throws VWException {
        if (wsdlDocument != null) {
            byte[] content = wsdlDocument.getContent();
            if (content != null) {
                return new String(content);
            }
            return null;
        }
        throw new VWException("filenet.ws.api.nullWSRRWSDLDocument", "null WSRR WSDL document");
    }

    public WSDLDocument getWSDLDocument() {
        return this.m_wsdlDocument;
    }

    public WSWSRRRegistry getWSRRRegistry() {
        return this.m_wsrrRegistry;
    }

    public String getBsrURI() {
        return this.m_wsdlDocument.getBsrURI().toString();
    }

    public String getOwner() {
        return this.m_wsdlDocument.getOwner();
    }

    public String getName() {
        return this.m_wsdlDocument.getName();
    }

    public String getNamespace() {
        return this.m_wsdlDocument.getNamespace();
    }

    public String getDescription() {
        return this.m_wsdlDocument.getDescription();
    }

    public String getVersion() {
        return this.m_wsdlDocument.getVersion();
    }

    public String getLastModified() {
        return this.m_wsdlDocument.getLastModified();
    }

    public String getEncoding() {
        return this.m_wsdlDocument.getEncoding();
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getP8WSRRDocumentURI() {
        return this.m_p8WSRRDocumentURI.toString();
    }

    public String getContent() {
        return this.m_content;
    }

    public String[] getUserDefinedProperties() {
        String[] props = null;
        if (this.m_props != null && this.m_props.length > 0) {
            props = new String[this.m_props.length * 2];
            for (int i = 0; i < this.m_props.length; ++i) {
                if (this.m_props[i] == null) continue;
                props[i * 2] = this.m_props[i].getName();
                props[i * 2 + 1] = this.m_props[i].getValue();
            }
        }
        return props;
    }

    public String getUserDefinedProperty(String key) {
        String value = null;
        if (this.m_properties != null) {
            value = (String)this.m_properties.get(key.trim());
        }
        return value;
    }

    public String toString() {
        return this.getName();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }
}

